/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.chloride.foundation.fps;

import java.util.Objects;
import me.srrapero720.chloride.ChlorideConfig;
import me.srrapero720.chloride.Tools;
import me.srrapero720.chloride.foundation.fps.AverageQueue;
import me.srrapero720.chloride.foundation.fps.FPSDisplay;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FrameTimer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="chloride", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class DebugOverlayEvent {
    private static final FPSDisplay DISPLAY = new FPSDisplay();
    private static final Component MSG_FPS = Component.m_237115_((String)"chloride.options.displayfps.fps");
    private static final Component MSG_MIN = Component.m_237115_((String)"chloride.options.displayfps.min");
    private static final Component MSG_AVG = Component.m_237115_((String)"chloride.options.displayfps.avg");
    private static final Component MSG_GPU = Component.m_237115_((String)"chloride.options.displayfps.gpu");
    private static final Component MSG_MEM = Component.m_237115_((String)"chloride.options.displayfps.mem");
    public static final AverageQueue AVERAGE = new AverageQueue();
    private static int fps = -1;
    private static int minFPS = -1;
    private static int avgFPS = -1;
    private static int gpuPercent = -1;
    private static int memUsage = -1;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderOverlayItem(RenderGuiOverlayEvent.Pre event) {
        if (!event.getOverlay().id().m_135815_().equals("debug_text")) {
            return;
        }
        if (Minecraft.m_91087_().f_91066_.f_92065_) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        fps = mc.m_260875_();
        minFPS = DebugOverlayEvent.minFPS(mc);
        memUsage = (int)(Tools.ramUsed() * 100L / Runtime.getRuntime().maxMemory());
        gpuPercent = Math.min((int)mc.m_231464_(), 100);
        avgFPS = AVERAGE.calculate();
        DebugOverlayEvent.renderFPSChar(mc, event.getGuiGraphics(), mc.f_91062_, event.getWindow().m_85449_());
    }

    private static void renderFPSChar(Minecraft mc, GuiGraphics graphics, Font font, double scale) {
        if (mc.f_91066_.f_92063_ || mc.f_91066_.f_92065_) {
            return;
        }
        ChlorideConfig.FPSDisplayMode mode = ChlorideConfig.fpsDisplayMode;
        ChlorideConfig.FPSDisplaySystemMode systemMode = ChlorideConfig.fpsDisplaySystemMode;
        if (mode.off() && systemMode.off()) {
            return;
        }
        DISPLAY.release();
        switch (mode) {
            case SIMPLE: {
                DISPLAY.append(Tools.colorByLow(fps)).add(DebugOverlayEvent.fix(fps)).add(" ").add(MSG_FPS.getString()).add(ChatFormatting.RESET);
                break;
            }
            case ADVANCED: {
                DISPLAY.append(Tools.colorByLow(fps)).add(DebugOverlayEvent.fix(fps)).add(ChatFormatting.RESET);
                DISPLAY.append(Tools.colorByLow(minFPS)).add(MSG_MIN).add(" ").add(DebugOverlayEvent.fix(minFPS)).add(ChatFormatting.RESET);
                DISPLAY.append(Tools.colorByLow(avgFPS)).add(MSG_AVG).add(" ").add(DebugOverlayEvent.fix(avgFPS)).add(ChatFormatting.RESET);
            }
        }
        if (!DISPLAY.isEmpty()) {
            DISPLAY.split();
        }
        switch (systemMode) {
            case GPU: {
                DISPLAY.append(Tools.colorByPercent(gpuPercent)).add(MSG_GPU).add(" ").add(DebugOverlayEvent.fix(gpuPercent)).add("%").add(ChatFormatting.RESET);
                break;
            }
            case RAM: {
                DISPLAY.append(Tools.colorByPercent(memUsage)).add(MSG_MEM).add(" ").add(DebugOverlayEvent.fix(memUsage)).add("%").add(ChatFormatting.RESET);
                break;
            }
            case ON: {
                DISPLAY.append(Tools.colorByPercent(gpuPercent)).add(MSG_GPU).add(" ").add(DebugOverlayEvent.fix(gpuPercent)).add("%").add(ChatFormatting.RESET);
                DISPLAY.append(Tools.colorByPercent(memUsage)).add(MSG_MEM).add(" ").add(DebugOverlayEvent.fix(memUsage)).add("%").add(ChatFormatting.RESET);
            }
        }
        if (DISPLAY.isEmpty()) {
            DISPLAY.add("FATAL ERROR");
        }
        float margin = scale > 0.0 ? (float)ChlorideConfig.fpsDisplayMargin / (float)scale : (float)ChlorideConfig.fpsDisplayMargin;
        String displayString = DISPLAY.toString();
        float maxPosX = graphics.m_280182_() - font.m_92895_(displayString);
        float posX = switch (ChlorideConfig.fpsDisplayGravity) {
            default -> throw new IncompatibleClassChangeError();
            case ChlorideConfig.FPSDisplayGravity.LEFT -> margin;
            case ChlorideConfig.FPSDisplayGravity.CENTER -> maxPosX / 2.0f;
            case ChlorideConfig.FPSDisplayGravity.RIGHT -> maxPosX - margin;
        };
        float posY = margin;
        graphics.m_280168_().m_85836_();
        if (ChlorideConfig.fpsDisplayShadow) {
            int n = (int)posX - 2;
            int n2 = (int)posY - 2;
            int n3 = (int)posX + font.m_92895_(displayString) + 2;
            Objects.requireNonNull(font);
            graphics.m_280509_(n, n2, n3, (int)(posY + 9.0f) + 1, -1873784752);
            graphics.m_280262_();
        }
        graphics.drawString(font, displayString, posX, posY, -1, true);
        DISPLAY.release();
        graphics.m_280168_().m_85849_();
    }

    private static String fix(int value) {
        return value == -1 ? "--" : "" + value;
    }

    private static int minFPS(Minecraft mc) {
        FrameTimer timer = mc.m_91293_();
        int start = timer.m_13754_();
        int end = timer.m_13761_();
        if (end == start) {
            return minFPS;
        }
        int fps = mc.m_260875_();
        if (fps <= 0) {
            fps = 1;
        }
        long[] frames = timer.m_13764_();
        long maxNS = (long)(1.0 / (double)fps * 1.0E9);
        long totalNS = 0L;
        int index = Math.floorMod(end - 1, frames.length);
        while (index != start && (double)totalNS < 1.0E9) {
            long timeNs = frames[index];
            if (timeNs > maxNS) {
                maxNS = timeNs;
            }
            totalNS += timeNs;
            index = Math.floorMod(index - 1, frames.length);
        }
        return (int)(1.0 / ((double)maxNS / 1.0E9));
    }
}

